/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.ICompressorRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CompressorCraftingCategory
implements IRecipeCategory<ICompressorRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("extendedcrafting", "textures/gui/jei/compressor.png");
    public static final ResourceLocation UID = new ResourceLocation("extendedcrafting", "compressor");
    private final IDrawable background;
    private final IDrawable icon;

    public CompressorCraftingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 149, 78);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.COMPRESSOR.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends ICompressorRecipe> getRecipeClass() {
        return ICompressorRecipe.class;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.compressor").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public List<Component> getTooltipStrings(ICompressorRecipe recipe, double mouseX, double mouseY) {
        if (mouseX > 1.0 && mouseX < 14.0 && mouseY > 1.0 && mouseY < 78.0) {
            return Arrays.asList(new TextComponent(NumberFormat.getInstance().format(recipe.getPowerCost()) + " FE"), new TextComponent(NumberFormat.getInstance().format(recipe.getPowerRate()) + " FE/t"));
        }
        if (mouseX > 54.0 && mouseX < 78.0 && mouseY > 58.0 && mouseY < 68.0) {
            return Collections.singletonList(ModTooltips.NUM_ITEMS.args(new Object[]{recipe.getInputCount()}).color(ChatFormatting.WHITE).build());
        }
        return Collections.emptyList();
    }

    public void setIngredients(ICompressorRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
        NonNullList inputs = NonNullList.m_122779_();
        inputs.addAll((Collection)recipe.m_7527_());
        inputs.add((Object)recipe.getCatalyst());
        ingredients.setInputIngredients((List)inputs);
    }

    public void setRecipe(IRecipeLayout layout, ICompressorRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0);
        stacks.init(0, true, 57, 30);
        stacks.init(1, true, 30, 30);
        stacks.init(2, false, 127, 30);
        stacks.set(0, (List)inputs.get(0));
        stacks.set(1, (List)inputs.get(1));
        stacks.set(2, outputs);
    }
}

